<?php

use Spatie\Watcher\Watch;

//https://stackoverflow.com/questions/26255208/long-running-background-process-in-php-on-windows-machine

require './vendor/autoload.php';

$photo_directory = './photo';
$logs_directory = './logs';

//$path = new SplFileInfo('photo\Safaricom_Drives_Gender_Diversity_and_Innovation_at_WOBN_Kenya.jpg');
//var_dump($path->getRealPath());exit;

define('CREATOR', 'PeterComputer');
define('UPLOAD_TOKEN', '94DkjpKgFCrIiDhOEBzufNzAbz4Tej80bL2mEmxwr+tv80pBZGDysSMj6QE7dtgd0sasbH5KUffcu6ZL3jiYARpdqLla7LxQ71YdcRjp7okP28jiN4Kin2qJob5yAkGRveETJhp9ONTAxSs2SLSo1jIo5UlfXL0gGagKYC9s4k09JPZ2I/10tZQA+shqgne08dLlZuMmOUgiUNp2dm1a0B5Qt8QwUA/mWSVEn1KhX8tgzmf4rnIo43nEN91+Vea1i2NA2cDTDik=');

$allowed_extensions = ['jpe', 'jpg', 'jpeg', 'png', 'tif', 'tiff', 'bmp'];

Watch::path($photo_directory)
    ->onAnyChange(function (string $type, string $path) use ($allowed_extensions, $logs_directory) {
        if ($type === Watch::EVENT_TYPE_FILE_CREATED) {

            $pathsa = explode('fileCreated - ', $path);

            //var_dump($pathsa);

            foreach ($pathsa as $patha) {

                $raw_file = pathinfo(trim($patha));

                $file_extension = $raw_file['extension'];

                if (in_array($file_extension, $allowed_extensions)) {

                    $file_path = realpath($raw_file['dirname'] . '/' . $raw_file['filename'] . '.' . $file_extension);

                    $result = upload($file_path);

                    $file_name = $raw_file['filename'] . '.' . $file_extension;
                    
                    echo $file_name;

                    $now = date("Y-m-d H:i:s");

                    if (str_contains($result, 'success')) {
                        $state = 'Successful';
                    } else {
                        $state = 'Failed';
                    }

                    logResult($logs_directory, $file_name, $state, $now, $result);

                    echo " - Upload " . $state . "\r\n";
                }

            }
            
            echo "Waiting now ......\r\n";
        }
    })
    ->start();

function logResult($logs_directory, $file_name, $result, $now, $info)
{

    $list = array(
        array($now, $file_name, $result, $info),
    );

    $file_name = date("Y_m_d") . '.csv';

    $fp = fopen($logs_directory . '/' . $file_name, 'a');

    foreach ($list as $fields) {
        fputcsv($fp, $fields);
    }

    fclose($fp);
}

function upload($path)
{

    $curl = curl_init();

    $proper_file = makeCurlFile($path);

    $data = [
        'photo' => $proper_file,
        'creator' => CREATOR
    ];

    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://pichamoto.biz/upload-images',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => $data,
        CURLOPT_HTTPHEADER => array(
            'Authorization: Bearer ' . UPLOAD_TOKEN
        ),
    ));

    $response = curl_exec($curl);

    if (curl_errno($curl)) {
        $response = curl_error($curl);
    }

    curl_close($curl);

    return $response;
}


function makeCurlFile($file)
{
    $mime = mime_content_type($file);
    $info = pathinfo($file);
    $name = $info['basename'];
    $output = new CURLFile($file, $mime, $name);
    return $output;
}
